"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Signals = void 0;
var _routes = require("./routes");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

class Signals {
  constructor(coreContext) {
    this.coreContext = coreContext;
    this.logger = coreContext.logger.get('signals');
  }
  start({
    core,
    kibanaRouter,
    searchguardBackendService
  }) {
    this.logger.debug('Start app');
    try {
      this.clusterClient = core.elasticsearch.client;
      (0, _routes.registerRoutes)({
        router: kibanaRouter,
        searchguardBackendService,
        clusterClient: this.clusterClient,
        logger: this.coreContext.logger
      });
    } catch (error) {
      this.logger.error(error);
    }
  }
}
exports.Signals = Signals;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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